/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.analysis.dpManager.Admin;

import ibm.nways.analysis.dpManager.Admin.DpAdminNotebook;
import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.DestinationPanel;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.modelgen.SnmpContextModel;
import ibm.nways.ras.Traces;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ResourceBundle;
import jclass.bwt.JCTabButton;
import jclass.util.JCEnvironment;

public class DpAdminDestinationPanel
extends Panel
implements DestinationPanel,
ActionListener {
    private DpAdminNotebook notebook;
    private Panel buttons;
    private Button previous;
    private Button next;
    private static ResourceBundle adminRB = ResourceBundle.getBundle("ibm.nways.analysis.dpManager.Admin.AdminResources");
    private static final String PREVIOUS_BUTTON_LABEL = adminRB.getString("s_Previous");
    private static final String NEXT_BUTTON_LABEL = adminRB.getString("s_Next");
    private NavigationContext myContext;
    private SnmpContextModel myModel;
    public static final String PORT_NUM_KEY = "portNum.eui.nhm.nways.ibm";
    private static boolean tracesInitialized;

    public DpAdminDestinationPanel() {
        this.setLayout(new BorderLayout());
        this.notebook = new DpAdminNotebook();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.previous) {
            JCTabButton[] jCTabButtonArray = this.notebook.getTabs();
            int n = this.notebook.getFirstVisibleTab();
            if (n > 0) {
                this.notebook.setFirstVisibleTab(n - 1);
                return;
            }
            this.notebook.setFirstVisibleTab(jCTabButtonArray.length - 1);
            return;
        }
        if (actionEvent.getSource() == this.next) {
            JCTabButton[] jCTabButtonArray = this.notebook.getTabs();
            int n = this.notebook.getFirstVisibleTab();
            if (n < jCTabButtonArray.length - 1) {
                this.notebook.setFirstVisibleTab(n + 1);
                return;
            }
            this.notebook.setFirstVisibleTab(0);
        }
    }

    public String getContextHostname() {
        String string = null;
        try {
            string = (String)((Object)this.myModel.getConfig().get("Config.Address"));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            Traces.logException(exception);
        }
        return string;
    }

    public Object getContext() {
        return this.myContext;
    }

    public void setContext(Object object) {
    }

    public void setNavContext(NavigationContext navigationContext) {
        this.myContext = navigationContext;
    }

    public NavigationContext getNavContext() {
        return this.myContext;
    }

    public void initDestPanel() {
        int n = 2099;
        this.setForeground(Color.black);
        if (JCEnvironment.getBrowser(this.getBrowser()) == 3) {
            this.buttons = new Panel();
            this.buttons.setForeground(Color.black);
            this.buttons.setLayout(new FlowLayout());
            this.previous = new Button(PREVIOUS_BUTTON_LABEL);
            this.previous.setBackground(Color.lightGray);
            this.previous.addActionListener(this);
            this.next = new Button(NEXT_BUTTON_LABEL);
            this.next.setBackground(Color.lightGray);
            this.next.addActionListener(this);
            this.buttons.add(this.previous);
            this.buttons.add(this.next);
            this.add("North", this.buttons);
        }
        this.add("Center", this.notebook);
        String string = this.notebook.getApplet().getDocumentBase().getHost();
        if (string == null || string.length() == 0) {
            try {
                String string2 = InetAddress.getLocalHost().getHostAddress();
                string = InetAddress.getByName(string2).getHostName();
            }
            catch (UnknownHostException unknownHostException) {
                string = null;
            }
            if (string == null || string.length() == 0) {
                string = new String("");
            }
        }
        this.notebook.initialize(string, n, this.notebook.getApplet());
    }

    public RemoteModel getModel() {
        return this.myModel;
    }

    public void setModel(RemoteModel remoteModel) {
        if (remoteModel instanceof SnmpContextModel) {
            this.myModel = (SnmpContextModel)remoteModel;
            return;
        }
        this.myModel = null;
    }

    public String getDestinationTitle() {
        return "";
    }

    public Component getComponent() {
        return this;
    }

    public void setBrowser(BrowserApplet browserApplet) {
        this.notebook.setApplet(browserApplet);
    }

    public BrowserApplet getBrowser() {
        return (BrowserApplet)this.notebook.getApplet();
    }
}

